/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.core.preferences;

import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.php.debug.core.interpreter.IInterpreter;
import com.aptana.php.debug.core.interpreter.IInterpreterProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org2.eclipse.php.internal.debug.core.interpreter.preferences.PHPexeItem;

public class CustomInterpretersProvider
implements IInterpreterProvider {
    private static final String SEPARATOR = ";";
    private List<IInterpreter> interpreters;
    private IInterpreter defaultInterpreter;

    public synchronized IInterpreter getDefaultInterpreter() {
        if (this.interpreters == null) {
            this.collectInterpretersInfo();
        }
        return this.defaultInterpreter;
    }

    public synchronized List<IInterpreter> getInterpreters() {
        if (this.interpreters == null) {
            this.collectInterpretersInfo();
        }
        return this.interpreters;
    }

    private void collectInterpretersInfo() {
        String[] defaults;
        String[] debuggers;
        this.interpreters = new ArrayList<IInterpreter>();
        IEclipsePreferences prefs = new InstanceScope().getNode("com.aptana.php.debug.epl");
        String namesString = prefs.get("com.aptana.php.debug.eplinstalledPHPNames", null);
        if (namesString == null) {
            namesString = "";
        }
        String[] names = !StringUtil.isEmpty((String)namesString) ? namesString.split(SEPARATOR) : ArrayUtil.NO_STRINGS;
        String locationsString = prefs.get("com.aptana.php.debug.eplinstalledPHPLocations", null);
        if (locationsString == null) {
            locationsString = "";
        }
        String[] phpExecutablesLocations = !StringUtil.isEmpty((String)locationsString) ? locationsString.split(SEPARATOR) : ArrayUtil.NO_STRINGS;
        String inisString = prefs.get("com.aptana.php.debug.eplinstalledPHPInis", null);
        if (inisString == null) {
            inisString = "";
        }
        String[] phpIniLocations = inisString.length() > 0 ? inisString.split(SEPARATOR) : new String[phpExecutablesLocations.length];
        String debuggersString = prefs.get("com.aptana.php.debug.eplinstalledPHPDebuggers", null);
        if (debuggersString == null) {
            debuggersString = "";
        }
        String[] stringArray = debuggers = !StringUtil.isEmpty((String)debuggersString) ? debuggersString.split(SEPARATOR) : ArrayUtil.NO_STRINGS;
        assert (names.length == phpExecutablesLocations.length);
        int i = 0;
        while (i < phpExecutablesLocations.length) {
            boolean filterItem;
            String iniLocation = "null".equals(phpIniLocations[i]) ? null : phpIniLocations[i];
            final PHPexeItem item = new PHPexeItem(names[i], phpExecutablesLocations[i], iniLocation, debuggers[i]);
            if (item.getExecutable() != null && !(filterItem = WorkbenchActivityHelper.filterItem((Object)new IPluginContribution(){

                public String getLocalId() {
                    return item.getDebuggerID();
                }

                public String getPluginId() {
                    return "com.aptana.php.debug.epl";
                }
            }))) {
                this.interpreters.add(item);
            }
            ++i;
        }
        String defaultsString = prefs.get("com.aptana.php.debug.eplinstalledPHPDefaults", null);
        if (defaultsString == null) {
            defaultsString = "";
        }
        String[] stringArray2 = defaults = !StringUtil.isEmpty((String)defaultsString) ? defaultsString.split(SEPARATOR) : ArrayUtil.NO_STRINGS;
        int n = defaults.length;
        int n2 = 0;
        while (n2 < n) {
            String defaultExe = stringArray2[n2];
            String[] debuggerDefault = defaultExe.split("=");
            if (debuggerDefault.length == 2) {
                for (IInterpreter interpreter : this.interpreters) {
                    PHPexeItem item = (PHPexeItem)interpreter;
                    if (!debuggerDefault[0].equals(item.getDebuggerID()) || !debuggerDefault[1].equals(item.getName())) continue;
                    this.defaultInterpreter = item;
                }
            }
            ++n2;
        }
    }
}

